import { defineConfig, HtmlTagDescriptor, Plugin } from "vite";
import react from "@vitejs/plugin-react";
import { resolve } from "path";
import federation from "@originjs/vite-plugin-federation";
import cssInjectedByJsPlugin from 'vite-plugin-css-injected-by-js';

export default defineConfig({
  define: {
    global: "window", // Define global for browser
  },
  plugins: [
    react(),
    federation({
      name: 'remote-app-1',
      filename: 'remoteEntry.js',
      exposes: {
        './RemoteAppRoutes': './src/routes/routes'
      },
      shared: ['react', 'react-dom', 'react-redux'],
    }),
    cssInjectedByJsPlugin({
      jsAssetsFilterFunction: (outputChunk) => { 
        // Only inject CSS into exposed federation components
        return outputChunk.fileName.includes('federation_expose_') ||
               outputChunk.fileName.includes('RemoteAppRoutes');
      },
      topExecutionPriority: false,
    })
  ],

  build: {
    target: 'es2022'
  },
    // Add these server and preview configurations
    server: {
      // This is for the development server (vite dev)
      cors: true,
    },
    preview: {
      // This is for the preview server (vite preview)
      port: 5000,
      strictPort: true,
      cors: true, // This is the key change!
    },

  resolve: {
    alias: {
      "@": resolve(__dirname, "src"),
    },
    extensions: [".js", ".jsx"],
  },
});