import { connect } from "react-redux";
import { EnactorProvider } from "@enactor/react-base-components";

// Setup the Connected Provider
const ConnectedEnactorProvider = connect((state, ownProps) => {
    const isConnected = true;
    return {
        isConnected,
        ...ownProps
    };
}, null)(EnactorProvider);

// Define the Wrapper HOC (High Order Component)
const withEnactorProvider = (WrappedComponent) => {
    return (props) => (
        <ConnectedEnactorProvider>
            <WrappedComponent {...props} />
        </ConnectedEnactorProvider>
    );
};


const routes = {

};


// Function to process routes and apply the wrapper to all components
const applyWrapperToRoutes = (routesMap) => {
    const processedRoutes = {};

    Object.keys(routesMap).forEach((routeKey) => {
        const routeConfig = routesMap[routeKey];
        
        // Copy the route config and replace the component with the wrapped version
        processedRoutes[routeKey] = {
            ...routeConfig,
            component: withEnactorProvider(routeConfig.component)
        };
    });

    return processedRoutes;

};

export default applyWrapperToRoutes(routes);
